<?php
include("conexao.php");
include_once("functions.php");
include_once(Idioma(1));
global $_TRA;

// Prepara a resposta em formato JSON
header('Content-Type: application/json');

if(ProtegePag() == true){

    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        
        $CadUser = InfoUser(2);
        $VerTeste = VerTeste($CadUser);

        $nome = (isset($_POST['nome'])) ? trim(htmlentities($_POST['nome'])) : '';
        $email = (isset($_POST['email'])) ? trim(htmlentities($_POST['email'])) : '';
        $celular = (isset($_POST['celular'])) ? trim(htmlentities($_POST['celular'])) : '';
        $Operadora = (isset($_POST['Operadora'])) ? trim($_POST['Operadora']) : '';

        if(empty($nome) || empty($email) || empty($celular) || empty($Operadora)){
            echo json_encode(['status' => 'error', 'message' => 'Todos os campos são obrigatórios.']);
            exit;
        }

        // Gera usuário e senha
        $gerarNums = gerarNums(5, 0, 9, $email);
        $usuario = $gerarNums[0];
        $senha = $gerarNums[1];

        $tempo = $VerTeste[1];
        $Premium = time() + (3600 * 24 * $tempo);
        $DataAtual = date('Y-m-d H:i:s');

        $SQL = "INSERT INTO teste (CadUser, nome, usuario, senha, email, conexao, perfil, data_cadastro, data_premio, celular) 
                VALUES (:CadUser, :nome, :usuario, :senha, :email, 1, :perfil, :data_cadastro, :data_premio, :celular)";
        $stmt = $painel_user->prepare($SQL);
        
        if ($stmt->execute([
            ':CadUser' => $CadUser,
            ':nome' => $nome,
            ':usuario' => $usuario,
            ':senha' => $senha,
            ':email' => $email,
            ':perfil' => $Operadora,
            ':data_cadastro' => $DataAtual,
            ':data_premio' => $Premium,
            ':celular' => $celular
        ])) {
            // Busca URL e Porta para retornar
            $SQLPerfilID = "SELECT id FROM perfil WHERE valorcsp = :valorcsp LIMIT 1";
            $stmtPerfil = $painel_geral->prepare($SQLPerfilID);
            $stmtPerfil->execute([':valorcsp' => $Operadora]);
            $LnPerfilID = $stmtPerfil->fetch();
            $id_perfil = $LnPerfilID['id'];
            
            $MaskPerfil = MaskPerfil($CadUser, $id_perfil);
            $url_conexao = $MaskPerfil[1];
            $porta_conexao = $MaskPerfil[2];
            $duracao_teste = $tempo . ($tempo > 1 ? " dias" : " dia");

            // Resposta de sucesso com todos os dados
            echo json_encode([
                'status' => 'success',
                'usuario' => $usuario,
                'senha' => $senha,
                'url' => $url_conexao,
                'porta' => $porta_conexao,
                'duracao' => $duracao_teste
            ]);

        } else {
            echo json_encode(['status' => 'error', 'message' => 'Ocorreu um erro ao salvar o teste no banco de dados.']);
        }
    }
} else {
     echo json_encode(['status' => 'error', 'message' => 'Acesso não autorizado.']);
}
?>