<?php
include("conexao.php");
include_once("functions.php");
include_once(Idioma(1));
global $_TRA;

if(!ProtegePag()){ exit; }

$CadUser = InfoUser(2);
$grupo = "N";

// 1. Busca a chave do chatbot no banco de dados
$sql = "SELECT chatbot_key FROM rev WHERE CadUser = :CadUser AND grupo = :grupo";
$stmt = $painel_acessos->prepare($sql);
$stmt->execute([':CadUser' => $CadUser, ':grupo' => $grupo]);
$result = $stmt->fetch(PDO::FETCH_ASSOC);
$chatbot_key = $result['chatbot_key'];

// 2. Se não existir uma chave, gera uma nova e salva no banco
if(empty($chatbot_key)) {
    $chatbot_key = bin2hex(random_bytes(16)); // Gera uma chave segura com 32 caracteres
    $update_sql = "UPDATE rev SET chatbot_key = :chatbot_key WHERE CadUser = :CadUser AND grupo = :grupo";
    $update_stmt = $painel_acessos->prepare($update_sql);
    $update_stmt->execute([':chatbot_key' => $chatbot_key, ':CadUser' => $CadUser, ':grupo' => $grupo]);
}

// 3. Monta a URL completa do webhook
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$domainName = $_SERVER['HTTP_HOST'];
$scriptPath = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
$webhook_url = $protocol . $domainName . $scriptPath . "/chatbot_integrado.php?key=" . $chatbot_key;

?>
<div class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title"><i class="fa fa-whatsapp"></i> Configuração do Chatbot de Teste Automático</h4>
            </div>
            <div class="modal-body">
                <p>Siga os passos abaixo para ativar o seu robô de testes automáticos no WhatsApp.</p>
                
                <h4>Passo 1: Copie sua URL de Webhook</h4>
                <p>Esta é a sua URL secreta. Ela conecta o aplicativo do seu celular ao seu painel. <strong>Não compartilhe com ninguém.</strong></p>
                <div class="input-group">
                    <input type="text" class="form-control" value="<?php echo htmlspecialchars($webhook_url); ?>" id="webhookUrlInput">
                    <span class="input-group-btn">
                        <button class="btn btn-primary" type="button" onclick="copiarUrl()">Copiar</button>
                    </span>
                </div>
                <br>

                <h4>Passo 2: Configure o App "SMS Auto Reply"</h4>
                <ol>
                    <li>Instale o aplicativo <a href="https://play.google.com/store/apps/details?id=com.lemi.smsautoreplytext" target="_blank">SMS Auto Reply - Autoresponder</a> no seu celular Android.</li>
                    <li>Abra o app e crie uma nova regra (+) para o <strong>WhatsApp</strong>.</li>
                    <li>No campo "SHOULD BE REPLIED...", digite as palavras-chave que ativarão o robô. Ex: <code>teste*</code> (o * significa que qualquer mensagem que comece com "teste" será respondida).</li>
                    <li>Role para baixo até a seção "SEND WEB RESPONSE" e ative a opção.</li>
                    <li>Cole a sua URL de Webhook (que você copiou acima) no campo "URL".</li>
                    <li>Salve a regra e dê as permissões que o aplicativo solicitar.</li>
                </ol>

                <h4>Pronto!</h4>
                <p>Agora, toda vez que alguém enviar a palavra-chave "teste" para o seu WhatsApp, seu painel irá gerar um teste e o robô responderá automaticamente com os dados de acesso.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<script>
function copiarUrl() {
    var copyText = document.getElementById("webhookUrlInput");
    copyText.select();
    copyText.setSelectionRange(0, 99999); // Para mobile
    document.execCommand("copy");
    alert("URL copiada para a área de transferência!");
}
</script>