<?php
// Define o tipo de conteúdo que será retornado. O app espera um JSON.
header('Content-Type: application/json; charset=utf-8');

// ===================================================================
// 1. CONFIGURAÇÃO DE SEGURANÇA E PALAVRAS-CHAVE
// ===================================================================

// CRIE SUA CHAVE SECRETA AQUI. Pode ser qualquer texto longo e difícil.
// Esta chave DEVE ser a mesma que você vai colocar na URL.
$chave_secreta_esperada = "MudarParaUmaChaveMuitoDificil12345"; 

// Palavras-chave para solicitar um teste
$palavras_chave_teste = ["teste", "testar", "quero um teste"];


// ===================================================================
// 2. VERIFICAÇÃO DE SEGURANÇA
// ===================================================================

// Pega a chave enviada na URL (?key=...)
$chave_recebida = isset($_GET['key']) ? $_GET['key'] : '';

// Se a chave recebida for diferente da esperada, o script para aqui.
// Isso impede que pessoas não autorizadas usem seu chatbot.
if ($chave_recebida !== $chave_secreta_esperada) {
    // Retorna uma resposta de erro em JSON e encerra o script.
    echo json_encode(["reply" => "ERRO: Acesso não autorizado."]);
    exit();
}


// ===================================================================
// 3. PROCESSAMENTO DA MENSAGEM
// ===================================================================

// O app "Auto Reply" envia a mensagem do cliente no parâmetro "query".
// Pegamos a mensagem, removemos espaços e convertemos para minúsculas para facilitar a comparação.
$mensagem_recebida = isset($_REQUEST['query']) ? strtolower(trim($_REQUEST['query'])) : '';

// Opcional: Pega o número de quem enviou a mensagem (pode ser útil no futuro).
$remetente = isset($_REQUEST['sender']) ? $_REQUEST['sender'] : '';


// Variável que guardará a resposta final
$resposta_final = "";


// ===================================================================
// 4. LÓGICA DO CHATBOT (O "CÉREBRO") - PERSONALIZE AQUI!
// ===================================================================

// Verifica se a mensagem recebida é vazia
if (empty($mensagem_recebida)) {
    $resposta_final = "testecs.";

} else {
    
    // Variável para controlar se uma palavra-chave de teste foi encontrada
    $encontrou_teste = false;

    // Loop para verificar se a mensagem contém alguma palavra-chave de teste
    foreach ($palavras_chave_teste as $palavra) {
        if (strpos($mensagem_recebida, $palavra) !== false) {
            $encontrou_teste = true;
            break; // Para o loop assim que encontrar a primeira correspondência
        }
    }

    // --- Defina suas respostas aqui ---

    if ($encontrou_teste) {
        // SE A MENSAGEM CONTÉM "teste", "testar", etc.
        // AQUI você colocaria a sua lógica para se conectar ao seu painel e gerar um teste.
        // Por enquanto, vamos apenas simular.
        $usuario_teste = "cliente" . rand(100, 999);
        $senha_teste = rand(1000, 9999);
        
        $resposta_final = "✅ Teste gerado com sucesso!\n\n*Usuário:* `{$usuario_teste}`\n*Senha:* `{$senha_teste}`\n\nUse estes dados para testar.";

    } else if ($mensagem_recebida == "oi" || $mensagem_recebida == "ola" || $mensagem_recebida == "olá") {
        // SE A MENSAGEM FOR "oi" ou "ola"
        $resposta_final = "Olá! 👋 Sou seu assistente virtual. Para solicitar um teste, digite *teste*.";

    } else if ($mensagem_recebida == "precos" || $mensagem_recebida == "preços" || $mensagem_recebida == "valor") {
        // SE A MENSAGEM FOR "preços" ou "valor"
        $resposta_final = "Nossos planos são:\n\n*Plano Mensal:* R$ 30,00\n*Plano Trimestral:* R$ 80,00\n\nPara solicitar um teste, digite *teste*.";

    } else {
        // RESPOSTA PADRÃO (se nenhuma das condições acima for atendida)
        $resposta_final = "Desculpe, não entendi. 🤔\n\nDigite *oi* para ver as opções ou *teste* para gerar um teste.";
    }
}


// ===================================================================
// 5. ENVIO DA RESPOSTA FINAL
// ===================================================================

// O app "Auto Reply" espera um JSON com uma chave chamada "reply".
// Montamos esse JSON e o imprimimos na tela.
$resposta_json = ["reply" => $resposta_final];

echo json_encode($resposta_json);

?>