<?php
// Define o tipo de conteúdo que será retornado. O app espera um JSON.
header('Content-Type: application/json; charset=utf-8');

// ===================================================================
// 1. CONFIGURAÇÃO DE SEGURANÇA E PALAVRAS-CHAVE
// ===================================================================

// CRIE SUA CHAVE SECRETA AQUI. Pode ser qualquer texto longo e difícil.
// Esta chave DEVE ser a mesma que você vai colocar na URL.
$chave_secreta_esperada = "MudarParaUmaChaveMuitoDificil12345";

// Palavras-chave para solicitar um teste
$palavras_chave_teste = ["teste", "testar", "quero um teste"];


// ===================================================================
// 2. VERIFICAÇÃO DE SEGURANÇA
// ===================================================================

// Pega a chave enviada na URL (?key=...)
$chave_recebida = isset($_GET['key']) ? $_GET['key'] : '';

// Se a chave recebida for diferente da esperada, o script para aqui.
// Isso impede que pessoas não autorizadas usem seu chatbot.
if ($chave_recebida !== $chave_secreta_esperada) {
    // Retorna uma resposta de erro em JSON e encerra o script.
    echo json_encode(["reply" => "ERRO: Acesso não autorizado."]);
    exit();
}


// ===================================================================
// 3. INCLUINDO AS DEPENDÊNCIAS DO PAINEL
// ===================================================================

// Agora, o chatbot precisa de conexão e funções do seu sistema
include("conexao.php");
include_once("functions.php");
include_once(Idioma(1));
global $_TRA;

// ===================================================================
// 4. PROCESSAMENTO DA MENSAGEM RECEBIDA
// ===================================================================

// Pega a mensagem recebida e a formata para comparação (minusculas e sem espaços no início/fim)
$mensagem_recebida = isset($_GET['msg']) ? strtolower(trim($_GET['msg'])) : '';


// ===================================================================
// 5. LÓGICA DO CHATBOT
// ===================================================================

if (in_array($mensagem_recebida, $palavras_chave_teste)) {
    // SE A MENSAGEM FOR UMA DAS PALAVRAS-CHAVE DE TESTE
    
    // ========================================================== //
    //           LÓGICA DE CRIAÇÃO REAL DO TESTE
    //      (ADAPTADO DO ARQUIVO EnviarCadTeste.php)
    // ========================================================== //

    // -----------------------------------------------------------
    // ATENÇÃO: Você precisa definir o $CadUser (ID do Revendedor)
    // para que o chatbot saiba qual conta criar o teste.
    // Altere o valor abaixo para o ID do revendedor que você
    // quer que seja responsável pelos testes do chatbot.
    // -----------------------------------------------------------
    $CadUser = 'seu_id_de_revendedor_aqui';
    $VerTeste = VerTeste($CadUser);

    if ($VerTeste[0] == 1) { // Verifica se há permissão para criar teste
        $nome = "Teste Chatbot";
        $email = "teste_chatbot_" . time() . "@seudominio.com";
        $celular = "00000000000"; // Celular genérico, pode ser ajustado
        $Operadora = "[vivo]"; // Exemplo de Operadora, pode ser ajustado
        $tempo = $VerTeste[1];
        $Premium = time() + (3600 * 24 * $tempo);

        // Gera o usuário e senha
        $gerarNums = gerarNums(5, 0, 9, $email);
        $usuario = $gerarNums[0];
        $senha = $gerarNums[1];

        // Insere o novo usuário no banco de dados
        $DataAtual = time();
        $SQL = "INSERT INTO usuario (nome, usuario, senha, email, perfil, data_cadastro, data_premio, celular) VALUES (:nome, :usuario, :senha, :email, :perfil, :data_cadastro, :data_premio, :celular)";
        $stmt = $painel_geral->prepare($SQL);

        if ($stmt->execute([
            ':nome' => $nome,
            ':usuario' => $usuario,
            ':senha' => $senha,
            ':email' => $email,
            ':perfil' => $Operadora,
            ':data_cadastro' => $DataAtual,
            ':data_premio' => $Premium,
            ':celular' => $celular
        ])) {
            // Sucesso! Formata a resposta
            $duracao_teste = $tempo . ($tempo > 1 ? " dias" : " dia");
            $resposta_final = "✅ Teste gerado com sucesso!\\n\\n*Usuário:* `{$usuario}`\\n*Senha:* `{$senha}`\\n*Duração:* `{$duracao_teste}`\\n\\nUse estes dados para testar.";

        } else {
            // Erro ao inserir no banco
            $resposta_final = "❌ Ocorreu um erro ao gerar o teste. Tente novamente mais tarde.";
        }

    } else {
        // Não tem permissão para criar testes
        $resposta_final = "❌ Desculpe, não foi possível gerar o teste no momento.";
    }


} else if ($mensagem_recebida == "oi" || $mensagem_recebida == "ola" || $mensagem_recebida == "olá") {
    // SE A MENSAGEM FOR "oi" ou "ola"
    $resposta_final = "Olá! 👋 Sou seu assistente virtual. Para solicitar um teste, digite *teste*.";

} else if ($mensagem_recebida == "precos" || $mensagem_recebida == "preços" || $mensagem_recebida == "valor") {
    // SE A MENSAGEM FOR "preços" ou "valor"
    $resposta_final = "Nossos planos são:\\n\\n*Plano Mensal:* R$ 30,00\\n*Plano Trimestral:* R$ 80,00\\n\\nPara solicitar um teste, digite *teste*.";

} else {
    // RESPOSTA PADRÃO (se nenhuma das condições acima for atendida)
    $resposta_final = "Desculpe, não entendi. 🤔\\n\\nDigite *oi* para ver as opções ou *teste* para gerar um teste.";
}

// ===================================================================
// 6. RETORNANDO A RESPOSTA FINAL EM JSON
// ===================================================================
echo json_encode(["reply" => $resposta_final]);

?>