<?php
header('Content-Type: application/json; charset=utf-8');

include("conexao.php");
include_once("functions.php");
include_once(Idioma(1));
global $_TRA, $painel_user, $painel_acessos;

// ===================================================================
// 1. CONFIGURAÇÕES GERAIS
// ===================================================================
$palavras_chave_teste = ["teste", "testar", "quero um teste", "gerar teste"];

// ===================================================================
// 2. VERIFICAÇÃO DE SEGURANÇA E IDENTIFICAÇÃO DO REVENDEDOR
// ===================================================================
$chave_recebida = isset($_GET['key']) ? $_GET['key'] : '';
if (empty($chave_recebida)) {
    echo json_encode(["reply" => "ERRO: Chave de acesso não fornecida."]);
    exit();
}

// Procura o revendedor pela chave do chatbot
$grupo = "N";
$sql = "SELECT CadUser FROM rev WHERE chatbot_key = :chatbot_key AND grupo = :grupo";
$stmt = $painel_acessos->prepare($sql);
$stmt->execute([':chatbot_key' => $chave_recebida, ':grupo' => $grupo]);
$revendedor = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$revendedor) {
    echo json_encode(["reply" => "ERRO: Acesso não autorizado. Chave inválida."]);
    exit();
}
$CadUser = $revendedor['CadUser']; // ID do revendedor foi encontrado!

// ===================================================================
// 3. PROCESSAMENTO DA MENSAGEM
// ===================================================================
$mensagem_recebida = isset($_REQUEST['query']) ? strtolower(trim($_REQUEST['query'])) : '';
$remetente = isset($_REQUEST['sender']) ? $_REQUEST['sender'] : ''; // Número de quem enviou

$resposta_final = "";

// ===================================================================
// 4. LÓGICA DO CHATBOT
// ===================================================================
$encontrou_teste = false;
foreach ($palavras_chave_teste as $palavra) {
    if (strpos($mensagem_recebida, $palavra) !== false) {
        $encontrou_teste = true;
        break;
    }
}

if ($encontrou_teste) {
    $VerTeste = VerTeste($CadUser);
    if ($VerTeste[0] == 1) { // Verifica se revendedor pode criar testes
        
        // Pega o primeiro perfil/operadora disponível para este revendedor
        $sql_perfil = "SELECT valorcsp FROM perfil WHERE CadUser = :CadUser LIMIT 1";
        $stmt_perfil = $painel_acessos->prepare($sql_perfil);
        $stmt_perfil->execute([':CadUser' => $CadUser]);
        $perfil_result = $stmt_perfil->fetch(PDO::FETCH_ASSOC);

        if (!$perfil_result) {
            $resposta_final = "❌ Desculpe, não há servidores de teste configurados para este revendedor.";
        } else {
            $Operadora = $perfil_result['valorcsp'];
            $nome = "Teste " . ucfirst(explode(" ", $remetente)[0]); // Usa o nome do contato se disponível
            $email = "teste_chatbot_" . time() . "@chatbot.com";
            $celular = $remetente;
            $tempo = $VerTeste[1];
            $Premium = time() + (3600 * 24 * $tempo);
            $DataAtual = date('Y-m-d H:i:s');
            
            $gerarNums = gerarNums(5, 0, 9, $email);
            $usuario = $gerarNums[0];
            $senha = $gerarNums[1];

            $SQL = "INSERT INTO teste (CadUser, nome, usuario, senha, email, conexao, perfil, data_cadastro, data_premio, celular) VALUES (:CadUser, :nome, :usuario, :senha, :email, 1, :perfil, :data_cadastro, :data_premio, :celular)";
            $stmt_insert = $painel_user->prepare($SQL);
            
            if ($stmt_insert->execute([':CadUser' => $CadUser,':nome' => $nome,':usuario' => $usuario,':senha' => $senha,':email' => $email,':perfil' => $Operadora,':data_cadastro' => $DataAtual,':data_premio' => $Premium,':celular' => $celular])) {
                $duracao_teste = $tempo . ($tempo > 1 ? " dias" : " dia");
                $resposta_final = "✅ Seu teste foi gerado com sucesso!\n\n*Usuário:* `{$usuario}`\n*Senha:* `{$senha}`\n\n_Válido por {$duracao_teste}._\n\nPara baixar o aplicativo e ver as instruções, acesse nosso site.";
            } else {
                $resposta_final = "❌ Ocorreu um erro interno ao gerar seu teste. Por favor, tente novamente mais tarde.";
            }
        }
    } else {
        $resposta_final = "❌ Desculpe, a geração de testes está desativada no momento.";
    }
} else if ($mensagem_recebida == "oi" || $mensagem_recebida == "ola" || $mensagem_recebida == "olá") {
    $resposta_final = "Olá! 👋 Sou um assistente virtual.\n\nPara receber um teste grátis, basta digitar a palavra *teste*.";
} else {
    $resposta_final = "Desculpe, não entendi. 🤔\n\nSe deseja um teste automático, digite *teste*.";
}

// ===================================================================
// 5. ENVIO DA RESPOSTA FINAL
// ===================================================================
echo json_encode(["reply" => $resposta_final]);

?>